using System;
using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Margaret Jablonski</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>03/12/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// VbecsDateTime data access layer class.
	///</summary>

	#endregion
	
	public class VbecsDateTime
	{
		#region Methods

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1226"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>String representing TimeZone</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3822"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets information about division time zone
		/// </summary>
		/// <returns></returns>
		public static string GetDivisionTimeZone()
		{
			SqlParameter[] _prms =
			{
				new SqlParameter(STOREDPROC.GetDivisionTimeZone.divisioncode, System.Data.SqlDbType.Char)
			};

			_prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
	
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetDivisionTimeZone.StoredProcName, _prms);

			if (ds.Tables[0].Rows[0][0].ToString() == string.Empty)
			{
				return "Time Zone is not setup for division " + Common.LogonUser.LogonUserDivisionCode; 
			}
			else
			{
				return (System.Convert.ToString(ds.Tables[0].Rows[0][0]));
			}
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/22/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8063"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8064"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetDivisionTimeZoneAbbreviation
		/// </summary>
		/// <returns></returns>
		public static string GetDivisionTimeZoneAbbreviation()
		{
			SqlParameter[] _prms =
			{
				new SqlParameter(STOREDPROC.GetDivisionTimeZoneAbbreviation.divisioncode, System.Data.SqlDbType.Char)
			};

			_prms[0].Value = Common.LogonUser.LogonUserDivisionCode;
	
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetDivisionTimeZoneAbbreviation.StoredProcName, _prms);

			return ds.Tables[0].Rows[0][Common.VbecsTables.TimeZone.TimeZoneName].ToString();
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1232"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1234"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets division current data time based on the converted server current time
		/// </summary>
		/// <returns></returns>
		public static System.DateTime GetDivisionCurrentDateTime()
		{
			return DAL.VbecsDateTime.GetDivisionCurrentDateTime(Common.LogonUser.LogonUserDivisionCode);
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1238"> 
		///		<ExpectedInput>DivisonCode</ExpectedInput>
		///		<ExpectedOutput>DateTime of Division</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1239"> 
		///		<ExpectedInput>Invalid Division</ExpectedInput>
		///		<ExpectedOutput>InvalidCastException</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets division current data time based on the converted server current time
		/// </summary>
		/// <param name="divisionCode">Division Code</param>
		/// <returns></returns>
		public static System.DateTime GetDivisionCurrentDateTime(string divisionCode)
		{
			SqlParameter[] _prms =
			{
				new SqlParameter(STOREDPROC.GetDivisionCurrentDateTime.divisioncode, System.Data.SqlDbType.Char)
			};

			_prms[0].Value = divisionCode;
	
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetDivisionCurrentDateTime.StoredProcName, _prms);

			if (ds.Tables[0].Rows[0][0].ToString() == string.Empty)
			{
				return System.DateTime.Now;
			}
			else
			{
				return (System.Convert.ToDateTime(ds.Tables[0].Rows[0][0]));
			}
		}

        /// <summary>
        /// Defect 210141 / CR 3211
        /// Converts DateTime to division time using offset in the hl7 date string
        /// </summary>
        /// <param name="hl7Date"></param>
        /// <param name="divisionCode"></param>
        /// <returns></returns>
        public static DateTime ConvertToDivisionTime(string hl7Date, string divisionCode)
        {
            DateTime finalResult;

            if (hl7Date.Length == 19)
            {
                DateTime divisionTime = GetDivisionCurrentDateTime(divisionCode);
                DateTime utcTime = DateTime.UtcNow;
                TimeSpan span = divisionTime - utcTime;

                int divisionOffset = 0;

                if (Math.Abs(span.Minutes) > 30)
                {
                    if (span.Hours >= 0)
                        divisionOffset = span.Hours + 1;
                    else
                        divisionOffset = span.Hours - 1;
                }
                else
                    divisionOffset = span.Hours;

                int year = Convert.ToInt32(hl7Date.Substring(0, 4));
                int month = Common.HL7DateFormat.CheckMonth(hl7Date.Substring(4, 2));
                int day = Common.HL7DateFormat.CheckDay(hl7Date.Substring(6, 2));
                int hour = Convert.ToInt32(hl7Date.Substring(8, 2));
                int minute = Convert.ToInt32(hl7Date.Substring(10, 2));
                int second = Common.HL7DateFormat.CheckSeconds(hl7Date.Substring(12, 2));
                int hl7TimeZoneOffset = Convert.ToInt32(hl7Date.Substring(14, 3));
                DateTime dt = new DateTime(year, month, day, hour, minute, second);

                DateTime utcDate = dt.AddHours(-hl7TimeZoneOffset);

                finalResult = utcDate.AddHours(divisionOffset);
            }
            else
            {
                finalResult = Common.HL7DateFormat.ConvertHL7DateTime(hl7Date);
            }

            return finalResult;
        }

        /// <summary>
        /// Defect 227795
        /// Adds time zone offset of the division to the datetime string
        /// </summary>
        /// <param name="date"></param>
        /// <param name="divisionCode"></param>
        /// <returns></returns>
        public static string AddDivisionTimeZoneForHL7Messages(DateTime date, string divisionCode)
        {
            string result = date.ToString("yyyyMMddHHmmss").Replace(":", "");
            DateTime divisionTime = GetDivisionCurrentDateTime(divisionCode);
            DateTime utcTime = DateTime.UtcNow;
            TimeSpan span = divisionTime - utcTime;

            int difference = 0;

            if (Math.Abs(span.Minutes) > 30)
            {
                if (span.Hours >= 0)
                    difference = span.Hours + 1;
                else
                    difference = span.Hours - 1;
            }
            else
                difference = span.Hours;

            if (difference > 0)
                result = result + "+";
            else
                result = result + "-";
            if (Math.Abs(difference) < 10)
                result = result + "0" + Math.Abs(difference).ToString();
            else
                result = result + Math.Abs(difference).ToString();

            result = result + "00";

            return result;
        }

		#endregion
	}
}
